﻿/*
	VERSION:		1.3
	1.3				Fix:  Failed loads don't break any promises,  they just successfully load undefined  (this keeps things from stalling)
	1.2				Fix:	Replaced queue-swapping with splice,  so that multiple items can be re-prioritized quickly
	1.1				Add:	Queue-swapping to prioritize the most recent requests
	
	USAGE: 
		#include "functions/queueLoad.as"
		getFileList = _this.queueLoad("files\\fileList.txt", myCache);
		getFileList.then = function( fileContents_str ){}
		
		
		#include "functions/queueLoad.as"
		_this.queueLoad( "charset\\image.png", myCache)
		.then = function( fileContents_bmp ){
			// 
		}// after loading()
		
		
		#include "functions/queueLoad.as"
		var myPath = "charset\\image.png";
		_this.queueLoad( myPath, myCache)
		.then = function( fileContents_bmp ){
			sendEvent("loadFile", {
				path: myPath, 
				image: fileContents_bmp
			});// sendEvent()
		}// after loading()
		
		
	WHAT THIS DOES: 
		Returns a promise for a requested file and queues the file to be loaded later.  (image, swf, or text)
		Files are loaded one at a time.  (when one finishes loading,  the next file starts loading)
		The same file won't get loaded more than once.  Repeated requests for a queued file returns the same promise for a single load of that file.
		Cached files are returned as immediately resolved promises.  (as if they loaded instantly)  (if a cache is provided)
		The most recently added files are loaded first.
		
		Automatically updates the provided cache when loading completes.  (if a cache is provided)
		
	
	LEAKS: 
		runFunc()
		_this
		queueLoad()
*/
if(!_this)		_this = this;
function runFunc( func ){
	return func.apply( _this, arguments.slice() );
}// runFunc()



runFunc(function(){
	#include "functions/VOW.as"
	#include "functions/VOW/loadFile.as"
	#include "functions/VOW/loadBitmap.as"
	
	var loadQueue = [];
	var itemsBeingLoaded = 0;
	
	_this.queueLoad = function( filePath, cache ){
		// return a promise for items that are already cached
		if( cache && cache[ filePath ] )		return VOW.make().keep(  cache[ filePath ]  );
		// else...
		
		// if:   not already in the cache
		// return a promise for items that are already being loaded
		var existingIndex = getQueuedIndex( filePath );
		var itemInQueue = loadQueue[ existingIndex ];
		if( itemInQueue.prom ){
			// prioritize this request to be loaded next,  by swapping it with the last item
			var newItem = reQueueIndex( existingIndex );
			// return a promise for items that are already being loaded,  which is now the last item
			return newItem.prom;
		}
		// else...
		
		// if:   not already in the queue
		var prom = VOW.make();
		// queue this item
		loadQueue.push( {
			filePath: filePath, 
			prom: prom
		} );
		
		// if not loading anything other than this
		// then start loading items
		if( itemsBeingLoaded === 0)		loadNextItem( cache );
		
		return prom;
	}// queueLoad()
	
	
	
	// find out where an item is in the queue,  based on filePath
	function getQueuedIndex( filePath ){
		for(var q=loadQueue.length-1; q>=0; q--){
			if( loadQueue[ q ].filePath === filePath )		return q;
		}
		return undefined;
	}// getQueuedIndex()
	
	
	
	// prioritize this item to load next
	function reQueueIndex( index ){
		// remove this item from its current position
		var removedItem = loadQueue.splice( index, 1 )[ 0 ];
		// re-add this item to the end
		loadQueue.push( removedItem );
		// provide the new item
		return removedItem;
	}// reQueueIndex()
	
	
	
	// async loop
	function loadNextItem( cache ){
		// loop stops when queue is empty
		// keep loading items until the queue is empty
		if( loadQueue.length === 0 )		return;
		// else...
		
		// loop decrements the queue each time it runs
		// remove the last item added to the queue  (most recent)
		var thisItem = loadQueue.pop();
		// start loading that item
		itemsBeingLoaded++;
		var currentLoad_prom = cacheLoad( thisItem.filePath, cache );
		currentLoad_prom.then( function( contents ){
			thisItem.prom.keep( contents );
		}, thisItem.prom.doBreak );
		currentLoad_prom.then( done, done );
		// succeed or fail,  continue
		function done(){
			itemsBeingLoaded--;
			loadNextItem( cache );
		}// done()
		// loadNextItem( cache );
	}// loadNextItem()
	
	
	
	/*
		Returns a promise for either a newly loaded file, or a cached file.  (if a cache is provided)
		Automatically updates the provided cache when loading completes.  (if a cache is provided)
	*/
	// _this.cacheLoad = cacheLoad;
	function cacheLoad( filePath, cache ){
		if( !filePath )		return VOW.make().keep( undefined );
		
		// return a promise for items that are already cached
		if( cache && cache[ filePath ] )		return VOW.make().keep(  cache[ filePath ]  );
		
		// resolve params
		// var prom = VOW.make().doBreak();
		// var prom = VOW.make().keep( undefined );
		var prom = VOW.make();
		
		
		// figure out what kind of file this is
		var extAt = filePath.lastIndexOf('.');
		var ext = filePath.substr( extAt+1 );
		var loadAs = 'text';
		// text
		if( ext === "txt" )		loadAs = 'text';
		if( ext === "xml" )		loadAs = 'text';
		if( ext === "json" )	loadAs = 'text';
		// image
		if( ext === "jpg" )	loadAs = 'image';
		if( ext === "jp3g" )	loadAs = 'image';
		if( ext === "gif" )	loadAs = 'image';
		if( ext === "png" )	loadAs = 'image';
		if( ext === "swf" )	loadAs = 'image';
		
		
		// load the file
		var loadProm;
		// if:  text file
		if( loadAs === 'text' ){
			loadProm = loadFile( filePath );
		}// if:  text file
		
		// if:  image/swf file
		if( loadAs === 'image' ){
			loadProm = loadBitmap( filePath );
		}// if:  image/swf file
		
		
		// update the cache
		if( cache ){
			loadProm.then = function( contents ){
				if( contents === undefined )		return;
				cache[ filePath ] = contents;
			}// after loading
		}// if:   a cache exists
		
		
		// failure >> successfully load undefined  (and resume)
		loadProm.then( prom.keep, prom.keep );
		/*	
		loadProm.then( function( content ){
			prom.keep( content );
		}, function(){
			prom.keep( undefined );
		});
		*/
		
		return prom;
	}// cacheLoad()
});// runFunc()